/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.eventservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nonnull;

public class Registration
implements EventRegistration,
Versioned {
    private UUID id;
    private String serviceName;
    private String topic;
    private EventFilter filter;
    private Address subscriber;
    private boolean localOnly;
    private transient Object listener;

    public Registration() {
    }

    public Registration(@Nonnull UUID id, String serviceName, String topic, EventFilter filter, Address subscriber, Object listener, boolean localOnly) {
        this.id = Preconditions.checkNotNull(id, "Registration ID cannot be null!");
        this.filter = filter;
        this.listener = listener;
        this.serviceName = serviceName;
        this.topic = topic;
        this.subscriber = subscriber;
        this.localOnly = localOnly;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTopic() {
        return this.topic;
    }

    @Override
    public EventFilter getFilter() {
        return this.filter;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Address getSubscriber() {
        return this.subscriber;
    }

    @Override
    public boolean isLocalOnly() {
        return this.localOnly;
    }

    public Object getListener() {
        return this.listener;
    }

    public void setListener(Object listener) {
        this.listener = listener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration that = (Registration)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.id);
        out.writeString(this.serviceName);
        out.writeString(this.topic);
        out.writeObject(this.subscriber);
        out.writeObject(this.filter);
        if (out.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            out.writeBoolean(this.localOnly);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.id = UUIDSerializationUtil.readUUID(in);
        this.serviceName = in.readString();
        this.topic = in.readString();
        this.subscriber = (Address)in.readObject();
        this.filter = (EventFilter)in.readObject();
        if (in.getVersion().isGreaterOrEqual(Versions.V5_3)) {
            this.localOnly = in.readBoolean();
        }
    }

    public String toString() {
        return "Registration{filter=" + this.filter + ", id='" + this.id + "', serviceName='" + this.serviceName + "', subscriber=" + this.subscriber + ", listener=" + this.listener + ", localOnly=" + this.localOnly + "}";
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 21;
    }
}

