/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution.init;

import com.hazelcast.cluster.Address;
import com.hazelcast.function.ComparatorEx;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.concurrent.ConcurrentConveyor;
import com.hazelcast.internal.util.concurrent.OneToOneConcurrentArrayQueue;
import com.hazelcast.internal.util.concurrent.QueuedPipe;
import com.hazelcast.internal.util.executor.ManagedExecutorService;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.TopologyChangedException;
import com.hazelcast.jet.function.RunnableEx;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.JobClassLoaderService;
import com.hazelcast.jet.impl.execution.ConcurrentInboundEdgeStream;
import com.hazelcast.jet.impl.execution.ConveyorCollector;
import com.hazelcast.jet.impl.execution.ConveyorCollectorWithPartition;
import com.hazelcast.jet.impl.execution.InboundEdgeStream;
import com.hazelcast.jet.impl.execution.OutboundCollector;
import com.hazelcast.jet.impl.execution.OutboundEdgeStream;
import com.hazelcast.jet.impl.execution.ProcessorTasklet;
import com.hazelcast.jet.impl.execution.ReceiverTasklet;
import com.hazelcast.jet.impl.execution.SenderTasklet;
import com.hazelcast.jet.impl.execution.SnapshotContext;
import com.hazelcast.jet.impl.execution.StoreSnapshotTasklet;
import com.hazelcast.jet.impl.execution.Tasklet;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.impl.execution.init.DagNodeUtil;
import com.hazelcast.jet.impl.execution.init.EdgeDef;
import com.hazelcast.jet.impl.execution.init.JetInitDataSerializerHook;
import com.hazelcast.jet.impl.execution.init.PartitionArrangement;
import com.hazelcast.jet.impl.execution.init.VertexDef;
import com.hazelcast.jet.impl.util.AsyncSnapshotWriterImpl;
import com.hazelcast.jet.impl.util.ImdgUtil;
import com.hazelcast.jet.impl.util.ObjectWithPartitionId;
import com.hazelcast.jet.impl.util.PrefixedLogger;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;

public class ExecutionPlan
implements IdentifiedDataSerializable {
    private static final int SNAPSHOT_QUEUE_SIZE = 1024;
    private Map<Address, int[]> partitionAssignment;
    private JobConfig jobConfig;
    private VertexDef[] vertices;
    private int memberIndex;
    private int memberCount;
    private long lastSnapshotId;
    private boolean isLightJob;
    private Subject subject;
    private final transient List<Tasklet> tasklets = new ArrayList<Tasklet>();
    private final transient Map<Address, Connection> memberConnections = new HashMap<Address, Connection>();
    private final transient Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> receiverMap = new HashMap<Integer, Map<Integer, Map<Address, ReceiverTasklet>>>();
    private final transient Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> senderMap = new HashMap<Integer, Map<Integer, Map<Address, SenderTasklet>>>();
    private final transient Map<String, ConcurrentConveyor<Object>[]> localConveyorMap = new HashMap<String, ConcurrentConveyor<Object>[]>();
    private final transient Map<String, Map<Address, ConcurrentConveyor<Object>>> edgeSenderConveyorMap = new HashMap<String, Map<Address, ConcurrentConveyor<Object>>>();
    private final transient List<Processor> processors = new ArrayList<Processor>();
    private transient PartitionArrangement ptionArrgmt;
    private transient NodeEngineImpl nodeEngine;
    private transient JobClassLoaderService jobClassLoaderService;
    private transient long executionId;
    private transient DagNodeUtil dagNodeUtil;
    private final transient Set<String> localCollectorsEdges = new HashSet<String>();
    private final transient Supplier<Set<Address>> remoteMembers = Util.memoize(() -> {
        HashSet<Address> remoteAddresses = new HashSet<Address>(this.partitionAssignment.keySet());
        remoteAddresses.remove(this.nodeEngine.getThisAddress());
        return remoteAddresses;
    });

    ExecutionPlan() {
    }

    ExecutionPlan(Map<Address, int[]> partitionAssignment, JobConfig jobConfig, long lastSnapshotId, int memberIndex, int memberCount, boolean isLightJob, Subject subject, int expectedVerticesCount) {
        this.partitionAssignment = partitionAssignment;
        this.jobConfig = jobConfig;
        this.lastSnapshotId = lastSnapshotId;
        this.memberIndex = memberIndex;
        this.memberCount = memberCount;
        this.isLightJob = isLightJob;
        this.subject = subject;
        this.vertices = new VertexDef[expectedVerticesCount];
    }

    public CompletableFuture<?> initialize(NodeEngineImpl nodeEngine, long jobId, long executionId, @Nonnull SnapshotContext snapshotContext, ConcurrentMap<String, File> tempDirectories, InternalSerializationService jobSerializationService) {
        this.nodeEngine = nodeEngine;
        this.jobClassLoaderService = ((JetServiceBackend)nodeEngine.getService("hz:impl:jetService")).getJobClassLoaderService();
        this.executionId = executionId;
        CompletableFuture<?> procSuppliersInitFuture = this.initProcSuppliers(jobId, tempDirectories, jobSerializationService);
        return procSuppliersInitFuture.thenAccept(r -> {
            this.initDag(jobSerializationService);
            this.ptionArrgmt = new PartitionArrangement(this.partitionAssignment, nodeEngine.getThisAddress(), this.jobConfig.getArgument("__sql.requiredPartitions") != null);
            Set<Integer> higherPriorityVertices = VertexDef.getHigherPriorityVertices(this.vertices);
            for (Address destAddr : this.remoteMembers.get()) {
                Connection conn = ImdgUtil.getMemberConnection(nodeEngine, destAddr);
                if (conn == null) {
                    throw new TopologyChangedException("no connection to job participant: " + destAddr);
                }
                this.memberConnections.put(destAddr, conn);
            }
            this.dagNodeUtil = new DagNodeUtil(Arrays.asList(this.vertices), this.partitionAssignment.keySet(), nodeEngine.getThisAddress());
            this.createLocalConveyorsAndSenderReceiverTasklets(jobId, jobSerializationService);
            for (VertexDef vertex : this.vertices) {
                if (!this.dagNodeUtil.vertexExists(vertex)) continue;
                ClassLoader processorClassLoader = this.isLightJob ? null : this.jobClassLoaderService.getProcessorClassLoader(jobId, vertex.name());
                Collection processors = Util.doWithClassLoader(processorClassLoader, () -> ExecutionPlan.createProcessors(vertex, vertex.localParallelism()));
                String jobPrefix = PrefixedLogger.prefix(this.jobConfig.getName(), jobId, vertex.name());
                ConcurrentConveyor<Object> ssConveyor = null;
                if (!this.isLightJob) {
                    QueuedPipe[] snapshotQueues = new QueuedPipe[vertex.localParallelism()];
                    Arrays.setAll(snapshotQueues, i -> new OneToOneConcurrentArrayQueue(1024));
                    ssConveyor = ConcurrentConveyor.concurrentConveyor(null, snapshotQueues);
                    ILogger storeSnapshotLogger = PrefixedLogger.prefixedLogger(nodeEngine.getLogger(StoreSnapshotTasklet.class), jobPrefix);
                    StoreSnapshotTasklet ssTasklet = new StoreSnapshotTasklet(snapshotContext, ConcurrentInboundEdgeStream.create(ssConveyor, 0, 0, true, jobPrefix + "/ssFrom", null), new AsyncSnapshotWriterImpl(nodeEngine, snapshotContext, vertex.name(), this.memberIndex, this.memberCount, jobSerializationService), storeSnapshotLogger, vertex.name(), higherPriorityVertices.contains(vertex.vertexId()));
                    this.tasklets.add(ssTasklet);
                }
                int localProcessorIdx = 0;
                for (Processor processor : processors) {
                    int globalProcessorIndex = this.memberIndex * vertex.localParallelism() + localProcessorIdx;
                    String processorPrefix = PrefixedLogger.prefix(this.jobConfig.getName(), jobId, vertex.name(), globalProcessorIndex);
                    ILogger logger = PrefixedLogger.prefixedLogger(nodeEngine.getLogger(processor.getClass()), processorPrefix);
                    Contexts.ProcCtx context = new Contexts.ProcCtx(nodeEngine, jobId, executionId, this.getJobConfig(), logger, vertex.name(), localProcessorIdx, globalProcessorIndex, this.isLightJob, this.partitionAssignment, vertex.localParallelism(), this.memberIndex, this.memberCount, tempDirectories, jobSerializationService, this.subject, processorClassLoader);
                    List<OutboundEdgeStream> outboundStreams = this.createOutboundEdgeStreams(vertex, localProcessorIdx);
                    List<InboundEdgeStream> inboundStreams = this.createInboundEdgeStreams(vertex, localProcessorIdx, jobPrefix, globalProcessorIndex);
                    ConveyorCollector snapshotCollector = ssConveyor == null ? null : new ConveyorCollector(ssConveyor, localProcessorIdx, null);
                    boolean isSource = vertex.inboundEdges().stream().allMatch(EdgeDef::isSnapshotRestoreEdge) && !vertex.isSnapshotVertex();
                    ProcessorTasklet processorTasklet = new ProcessorTasklet(context, nodeEngine.getExecutionService().getExecutor("jet:tasklet_initClose"), jobSerializationService, processor, inboundStreams, outboundStreams, snapshotContext, snapshotCollector, isSource);
                    this.tasklets.add(processorTasklet);
                    this.processors.add(processor);
                    ++localProcessorIdx;
                }
            }
        });
    }

    private void createLocalConveyorsAndSenderReceiverTasklets(long jobId, InternalSerializationService jobSerializationService) {
        for (VertexDef vertex : this.vertices) {
            String jobPrefix = PrefixedLogger.prefix(this.jobConfig.getName(), jobId, vertex.name());
            for (EdgeDef outboundEdge : vertex.outboundEdges()) {
                this.createLocalConveyorsAndSenderTaskletsForOutbound(outboundEdge, jobPrefix, jobSerializationService);
            }
            for (EdgeDef inboundEdge : vertex.inboundEdges()) {
                this.createLocalConveyorsAndReceiverTaskletsForInbound(inboundEdge, jobPrefix, jobSerializationService);
            }
        }
    }

    private void createLocalConveyorsAndSenderTaskletsForOutbound(EdgeDef outboundEdge, String jobPrefix, InternalSerializationService jobSerializationService) {
        Set<Address> edgeTargets = this.dagNodeUtil.getEdgeTargets(outboundEdge);
        for (Address targetAddress : edgeTargets) {
            if (!targetAddress.equals(this.nodeEngine.getThisAddress())) continue;
            this.localCollectorsEdges.add(outboundEdge.edgeId());
            this.populateLocalConveyorMap(outboundEdge);
        }
        if (!outboundEdge.isLocal()) {
            this.createSenderTasklets(outboundEdge, jobPrefix, jobSerializationService);
        }
    }

    private void createLocalConveyorsAndReceiverTaskletsForInbound(EdgeDef inboundEdge, String jobPrefix, InternalSerializationService jobSerializationService) {
        Set<Address> edgeSources = this.dagNodeUtil.getEdgeSources(inboundEdge);
        for (Address sourceAddress : edgeSources) {
            this.populateLocalConveyorMap(inboundEdge);
            if (sourceAddress.equals(this.nodeEngine.getThisAddress())) {
                this.localCollectorsEdges.add(inboundEdge.edgeId());
                continue;
            }
            this.createReceiverTasklet(inboundEdge, jobPrefix, jobSerializationService);
        }
    }

    public Map<Integer, Map<Integer, Map<Address, ReceiverTasklet>>> getReceiverMap() {
        return this.receiverMap;
    }

    public Map<Integer, Map<Integer, Map<Address, SenderTasklet>>> getSenderMap() {
        return this.senderMap;
    }

    public List<Tasklet> getTasklets() {
        return this.tasklets;
    }

    public JobConfig getJobConfig() {
        return this.jobConfig;
    }

    void setVertex(int position, VertexDef vertex) {
        this.vertices[position] = vertex;
    }

    @Override
    public int getFactoryId() {
        return JetInitDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        ImdgUtil.writeArray(out, this.vertices);
        out.writeLong(this.lastSnapshotId);
        out.writeObject(this.partitionAssignment);
        out.writeBoolean(this.isLightJob);
        out.writeObject(this.jobConfig);
        out.writeInt(this.memberIndex);
        out.writeInt(this.memberCount);
        ImdgUtil.writeSubject(out, this.subject);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.vertices = (VertexDef[])ImdgUtil.readArray(in, VertexDef[]::new);
        this.lastSnapshotId = in.readLong();
        this.partitionAssignment = (Map)in.readObject();
        this.isLightJob = in.readBoolean();
        this.jobConfig = (JobConfig)in.readObject();
        this.memberIndex = in.readInt();
        this.memberCount = in.readInt();
        this.subject = ImdgUtil.readSubject(in);
    }

    private CompletableFuture<?> initProcSuppliers(long jobId, ConcurrentMap<String, File> tempDirectories, InternalSerializationService jobSerializationService) {
        CompletableFuture[] futures = new CompletableFuture[this.vertices.length];
        int index = 0;
        ManagedExecutorService offloadExecutor = this.nodeEngine.getExecutionService().getExecutor("hz:jet-job-offloadable");
        for (VertexDef vertex : this.vertices) {
            ClassLoader processorClassLoader = this.isLightJob ? null : this.jobClassLoaderService.getProcessorClassLoader(jobId, vertex.name());
            ProcessorSupplier supplier = vertex.processorSupplier();
            RunnableEx action = () -> {
                String prefix = PrefixedLogger.prefix(this.jobConfig.getName(), jobId, vertex.name(), "#PS");
                ILogger logger = PrefixedLogger.prefixedLogger(this.nodeEngine.getLogger(supplier.getClass()), prefix);
                Util.doWithClassLoader(processorClassLoader, () -> supplier.init(new Contexts.ProcSupplierCtx(this.nodeEngine, jobId, this.executionId, this.jobConfig, logger, vertex.name(), vertex.localParallelism(), vertex.localParallelism() * this.memberCount, this.memberIndex, this.memberCount, this.isLightJob, this.partitionAssignment, tempDirectories, jobSerializationService, this.subject, processorClassLoader)));
            };
            Executor executor = supplier.initIsCooperative() ? ConcurrencyUtil.CALLER_RUNS : offloadExecutor;
            futures[index++] = CompletableFuture.runAsync(action, executor);
        }
        return CompletableFuture.allOf(futures);
    }

    private void initDag(InternalSerializationService jobSerializationService) {
        Map<Integer, VertexDef> vMap = Arrays.stream(this.vertices).collect(Collectors.toMap(VertexDef::vertexId, v -> v));
        for (VertexDef v2 : this.vertices) {
            v2.inboundEdges().forEach(e -> e.initTransientFields(vMap, v2, false));
            v2.outboundEdges().forEach(e -> e.initTransientFields(vMap, v2, true));
        }
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        Arrays.stream(this.vertices).map(VertexDef::outboundEdges).flatMap(Collection::stream).map(EdgeDef::partitioner).filter(Objects::nonNull).forEach(partitioner -> {
            if (partitioner instanceof SerializationServiceAware) {
                SerializationServiceAware serializationServiceAware = (SerializationServiceAware)((Object)partitioner);
                serializationServiceAware.setSerializationService(jobSerializationService);
            }
            partitioner.init(object -> partitionService.getPartitionId((Data)jobSerializationService.toData(object)));
        });
    }

    private static Collection<? extends Processor> createProcessors(VertexDef vertexDef, int parallelism) {
        ProcessorSupplier processorSupplier = vertexDef.processorSupplier();
        Collection<? extends Processor> processors = processorSupplier.get(parallelism);
        if (processors.size() != parallelism) {
            throw new JetException("ProcessorSupplier failed to return the requested number of processors. Requested: " + parallelism + ", returned: " + processors.size());
        }
        return processors;
    }

    private List<OutboundEdgeStream> createOutboundEdgeStreams(VertexDef vertex, int processorIdx) {
        ArrayList<OutboundEdgeStream> outboundStreams = new ArrayList<OutboundEdgeStream>();
        for (EdgeDef edge : vertex.outboundEdges()) {
            OutboundCollector outboundCollector = this.createOutboundCollector(edge, processorIdx);
            OutboundEdgeStream outboundEdgeStream = new OutboundEdgeStream(edge.sourceOrdinal(), outboundCollector);
            outboundStreams.add(outboundEdgeStream);
        }
        return outboundStreams;
    }

    private OutboundCollector createOutboundCollector(EdgeDef edge, int processorIndex) {
        if (edge.routingPolicy() == Edge.RoutingPolicy.ISOLATED && !edge.isLocal()) {
            throw new IllegalArgumentException("Isolated edges must be local: " + edge);
        }
        int totalPartitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        int[][] partitionsPerProcessor = this.getLocalPartitionDistribution(edge, edge.destVertex().localParallelism());
        OutboundCollector localCollector = null;
        if (this.localCollectorsEdges.contains(edge.edgeId())) {
            localCollector = this.createLocalOutboundCollector(edge, processorIndex, totalPartitionCount, partitionsPerProcessor);
            if (edge.isLocal()) {
                return localCollector;
            }
        }
        OutboundCollector[] remoteCollectors = this.createRemoteOutboundCollectors(edge, processorIndex);
        if (localCollector == null) {
            return OutboundCollector.compositeCollector(remoteCollectors, edge, totalPartitionCount, false, true);
        }
        OutboundCollector[] collectors = new OutboundCollector[remoteCollectors.length + 1];
        collectors[0] = localCollector;
        System.arraycopy(remoteCollectors, 0, collectors, 1, collectors.length - 1);
        return OutboundCollector.compositeCollector(collectors, edge, totalPartitionCount, false, false);
    }

    private void populateLocalConveyorMap(EdgeDef edge) {
        if (this.localConveyorMap.containsKey(edge.edgeId())) {
            return;
        }
        int upstreamParallelism = edge.sourceVertex().localParallelism();
        int downstreamParallelism = edge.destVertex().localParallelism();
        int queueSize = edge.getConfig().getQueueSize();
        int numRemoteMembers = this.dagNodeUtil.numRemoteSources(edge);
        if (edge.routingPolicy() == Edge.RoutingPolicy.ISOLATED) {
            int queueCount = upstreamParallelism / downstreamParallelism;
            int remainder = upstreamParallelism % downstreamParallelism;
            this.localConveyorMap.put(edge.edgeId(), (ConcurrentConveyor[])Stream.concat(Arrays.stream(ExecutionPlan.createConveyorArray(remainder, queueCount + 1, queueSize)), Arrays.stream(ExecutionPlan.createConveyorArray(downstreamParallelism - remainder, Math.max(1, queueCount), queueSize))).toArray(ConcurrentConveyor[]::new));
        } else {
            int queueCount = !this.localCollectorsEdges.contains(edge.edgeId()) ? numRemoteMembers : upstreamParallelism + (!edge.isLocal() ? numRemoteMembers : 0);
            this.localConveyorMap.put(edge.edgeId(), ExecutionPlan.createConveyorArray(downstreamParallelism, queueCount, queueSize));
        }
    }

    private OutboundCollector createLocalOutboundCollector(EdgeDef edge, int processorIndex, int totalPartitionCount, int[][] partitionsPerProcessor) {
        int upstreamParallelism = edge.sourceVertex().localParallelism();
        int downstreamParallelism = edge.destVertex().localParallelism();
        ConcurrentConveyor[] localConveyors = this.localConveyorMap.get(edge.edgeId());
        if (edge.routingPolicy() == Edge.RoutingPolicy.ISOLATED) {
            OutboundCollector[] localCollectors = (OutboundCollector[])IntStream.range(0, downstreamParallelism).filter(i -> i % upstreamParallelism == processorIndex % downstreamParallelism).mapToObj(i -> new ConveyorCollector(localConveyors[i], processorIndex / downstreamParallelism, null)).toArray(OutboundCollector[]::new);
            return OutboundCollector.compositeCollector(localCollectors, edge, totalPartitionCount, true, false);
        }
        OutboundCollector[] localCollectors = new OutboundCollector[downstreamParallelism];
        Arrays.setAll(localCollectors, n -> new ConveyorCollector(localConveyors[n], processorIndex, partitionsPerProcessor[n]));
        return OutboundCollector.compositeCollector(localCollectors, edge, totalPartitionCount, true, false);
    }

    private OutboundCollector[] createRemoteOutboundCollectors(EdgeDef edge, int processorIndex) {
        if (!edge.getDistributedTo().equals(Edge.DISTRIBUTE_TO_ALL)) {
            if (edge.routingPolicy() != Edge.RoutingPolicy.PARTITIONED) {
                throw new JetException("An edge distributing to a specific member must be partitioned: " + edge);
            }
            if (!this.ptionArrgmt.getRemotePartitionAssignment().containsKey(edge.getDistributedTo()) && !edge.getDistributedTo().equals(this.nodeEngine.getThisAddress())) {
                throw new JetException("The target member of an edge is not present in the cluster or is a lite member: " + edge);
            }
        }
        Map<Address, ConcurrentConveyor<Object>> senderConveyorMap = this.edgeSenderConveyorMap.get(edge.edgeId());
        Address distributeTo = edge.getDistributedTo();
        Map<Address, int[]> memberToPartitions = distributeTo.equals(Edge.DISTRIBUTE_TO_ALL) ? this.ptionArrgmt.getRemotePartitionAssignment() : this.ptionArrgmt.remotePartitionAssignmentToOne(distributeTo);
        ArrayList<ConveyorCollectorWithPartition> remoteCollectors = new ArrayList<ConveyorCollectorWithPartition>(memberToPartitions.size());
        for (Map.Entry<Address, int[]> entry : memberToPartitions.entrySet()) {
            Address memberAddress = entry.getKey();
            int[] memberPartitions = entry.getValue();
            ConcurrentConveyor<Object> conveyor = senderConveyorMap.get(memberAddress);
            if (conveyor == null) continue;
            remoteCollectors.add(new ConveyorCollectorWithPartition(conveyor, processorIndex, memberPartitions));
        }
        return remoteCollectors.toArray(new OutboundCollector[0]);
    }

    private void createSenderTasklets(EdgeDef edge, String jobPrefix, InternalSerializationService jobSerializationService) {
        assert (!edge.isLocal()) : "Edge is not distributed";
        if (this.edgeSenderConveyorMap.containsKey(edge.edgeId())) {
            return;
        }
        int destVertexId = edge.destVertex().vertexId();
        HashMap<Address, ConcurrentConveyor<Object>> addrToConveyor = new HashMap<Address, ConcurrentConveyor<Object>>();
        ComparatorEx<?> origComparator = edge.getOrderComparator();
        ComparatorEx<ObjectWithPartitionId> adaptedComparator = origComparator == null ? null : (l, r) -> origComparator.compare(l.getItem(), r.getItem());
        for (Address destAddr : this.dagNodeUtil.getEdgeTargets(edge)) {
            if (destAddr.equals(this.nodeEngine.getThisAddress())) continue;
            ConcurrentConveyor<Object> conveyor = ExecutionPlan.createConveyorArray(1, edge.sourceVertex().localParallelism(), edge.getConfig().getQueueSize())[0];
            InboundEdgeStream inboundEdgeStream = this.newEdgeStream(edge, conveyor, jobPrefix + "/toVertex:" + edge.destVertex().name() + "-toMember:" + destAddr, adaptedComparator);
            SenderTasklet t = new SenderTasklet(inboundEdgeStream, this.nodeEngine, destAddr, this.memberConnections.get(destAddr), destVertexId, edge.getConfig().getPacketSizeLimit(), this.executionId, edge.sourceVertex().name(), edge.sourceOrdinal(), jobSerializationService);
            this.senderMap.computeIfAbsent(destVertexId, xx -> new HashMap()).computeIfAbsent(edge.destOrdinal(), xx -> new HashMap()).put(destAddr, t);
            this.tasklets.add(t);
            addrToConveyor.put(destAddr, conveyor);
        }
        this.edgeSenderConveyorMap.put(edge.edgeId(), addrToConveyor);
    }

    private static ConcurrentConveyor<Object>[] createConveyorArray(int count, int queueCount, int queueSize) {
        ConcurrentConveyor[] concurrentConveyors = new ConcurrentConveyor[count];
        Arrays.setAll(concurrentConveyors, i -> {
            QueuedPipe[] queues = new QueuedPipe[queueCount];
            Arrays.setAll(queues, j -> new OneToOneConcurrentArrayQueue(queueSize));
            return ConcurrentConveyor.concurrentConveyor(null, queues);
        });
        return concurrentConveyors;
    }

    private int[][] getLocalPartitionDistribution(EdgeDef edge, int downstreamParallelism) {
        if (!edge.routingPolicy().equals(Edge.RoutingPolicy.PARTITIONED)) {
            return new int[downstreamParallelism][];
        }
        if (edge.isLocal() || this.nodeEngine.getThisAddress().equals(edge.getDistributedTo())) {
            return this.ptionArrgmt.assignPartitionsToProcessors(downstreamParallelism, false);
        }
        if (edge.getDistributedTo().equals(Edge.DISTRIBUTE_TO_ALL)) {
            return this.ptionArrgmt.assignPartitionsToProcessors(downstreamParallelism, true);
        }
        int[][] res = new int[downstreamParallelism][];
        Arrays.fill((Object[])res, new int[0]);
        return res;
    }

    private void createReceiverTasklet(EdgeDef inboundEdge, String jobPrefix, InternalSerializationService jobSerializationService) {
        int totalPartitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
        int[][] partitionsPerProcessor = this.getLocalPartitionDistribution(inboundEdge, inboundEdge.destVertex().localParallelism());
        this.createReceiverTasklet(inboundEdge, jobPrefix, partitionsPerProcessor, totalPartitionCount, jobSerializationService);
    }

    private void createReceiverTasklet(EdgeDef edge, String jobPrefix, int[][] ptionsPerProcessor, int totalPtionCount, InternalSerializationService jobSerializationService) {
        ConcurrentConveyor[] localConveyors = this.localConveyorMap.get(edge.edgeId());
        this.receiverMap.computeIfAbsent(edge.destVertex().vertexId(), x -> new HashMap()).computeIfAbsent(edge.destOrdinal(), x -> {
            HashMap<Address, ReceiverTasklet> addrToTasklet = new HashMap<Address, ReceiverTasklet>();
            int offset = 0;
            for (Address addr : this.ptionArrgmt.getRemotePartitionAssignment().keySet()) {
                if (!this.dagNodeUtil.getEdgeSources(edge).contains(addr)) continue;
                OutboundCollector[] collectors = new OutboundCollector[ptionsPerProcessor.length];
                int queueOffset = --offset;
                Arrays.setAll(collectors, n -> new ConveyorCollector(localConveyors[n], localConveyors[n].queueCount() + queueOffset, ptionsPerProcessor[n]));
                OutboundCollector collector = OutboundCollector.compositeCollector(collectors, edge, totalPtionCount, true, false);
                ReceiverTasklet receiverTasklet = new ReceiverTasklet(collector, jobSerializationService, edge.getConfig().getReceiveWindowMultiplier(), this.getJetConfig().getFlowControlPeriodMs(), this.nodeEngine.getLoggingService(), addr, edge.destOrdinal(), edge.destVertex().name(), this.memberConnections.get(addr), jobPrefix);
                addrToTasklet.put(addr, receiverTasklet);
                this.tasklets.add(receiverTasklet);
            }
            return addrToTasklet;
        });
    }

    private JetConfig getJetConfig() {
        return this.nodeEngine.getConfig().getJetConfig();
    }

    private List<InboundEdgeStream> createInboundEdgeStreams(VertexDef srcVertex, int localProcessorIdx, String jobPrefix, int globalProcessorIdx) {
        ArrayList<InboundEdgeStream> inboundStreams = new ArrayList<InboundEdgeStream>();
        for (EdgeDef inEdge : srcVertex.inboundEdges()) {
            if (this.dagNodeUtil.getEdgeSources(inEdge).isEmpty()) continue;
            ConcurrentConveyor<Object> conveyor = this.localConveyorMap.get(inEdge.edgeId())[localProcessorIdx];
            inboundStreams.add(this.newEdgeStream(inEdge, conveyor, jobPrefix + "#" + globalProcessorIdx, inEdge.getOrderComparator()));
        }
        return inboundStreams;
    }

    private InboundEdgeStream newEdgeStream(EdgeDef inEdge, ConcurrentConveyor<Object> conveyor, String debugName, ComparatorEx<?> comparator) {
        return ConcurrentInboundEdgeStream.create(conveyor, inEdge.destOrdinal(), inEdge.priority(), this.jobConfig.getProcessingGuarantee() == ProcessingGuarantee.EXACTLY_ONCE, debugName, comparator);
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public long lastSnapshotId() {
        return this.lastSnapshotId;
    }

    public int getStoreSnapshotTaskletCount() {
        return (int)this.tasklets.stream().filter(t -> t instanceof StoreSnapshotTasklet).count();
    }

    public int getProcessorTaskletCount() {
        return (int)this.tasklets.stream().filter(t -> t instanceof ProcessorTasklet).count();
    }

    public int getHigherPriorityVertexCount() {
        return VertexDef.getHigherPriorityVertices(this.vertices).size();
    }

    public List<VertexDef> getVertices() {
        return Collections.unmodifiableList(Arrays.asList(this.vertices));
    }
}

