/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.server.tcp.LinkedAddresses;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.logging.ILogger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalAddressRegistry {
    private final ConcurrentMap<Address, UUID> addressToUuid = new ConcurrentHashMap<Address, UUID>();
    private final ConcurrentMap<UUID, Pair> uuidToAddresses = new ConcurrentHashMap<UUID, Pair>();
    private final ILogger logger;
    private volatile UUID localUuid;
    private volatile LinkedAddresses localAddresses;

    protected LocalAddressRegistry(ILogger logger) {
        this.logger = logger;
    }

    public LocalAddressRegistry(Node node, AddressPicker addressPicker) {
        this(node.getLogger(LocalAddressRegistry.class));
        this.registerLocalAddresses(node.getThisUuid(), addressPicker);
    }

    public void register(@Nonnull UUID instanceUuid, @Nonnull LinkedAddresses linkedAddresses) {
        if (instanceUuid.equals(this.localUuid)) {
            this.localAddresses.addLinkedAddresses(linkedAddresses);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("This member connected to itself since some its addresses are unknown to itself." + linkedAddresses + "registered for the local member uuid=" + instanceUuid + " currently all registered addresses for this local member: " + this.localAddresses);
            }
            return;
        }
        this.uuidToAddresses.compute(instanceUuid, (uuid, linkedAddressesRegistrationCountPair) -> {
            if (linkedAddressesRegistrationCountPair == null) {
                linkedAddressesRegistrationCountPair = new Pair(linkedAddresses, new AtomicInteger(1));
            } else {
                LinkedAddresses previousAddresses = linkedAddressesRegistrationCountPair.getAddresses();
                AtomicInteger registrationCount = linkedAddressesRegistrationCountPair.registrationCount;
                if (previousAddresses.intersects(linkedAddresses)) {
                    previousAddresses.addLinkedAddresses(linkedAddresses);
                    registrationCount.incrementAndGet();
                } else {
                    linkedAddressesRegistrationCountPair = new Pair(linkedAddresses, new AtomicInteger(1));
                    previousAddresses.getAllAddresses().forEach(address -> this.addressToUuid.remove(address, uuid));
                    this.logger.warning(previousAddresses + " previously registered for the instance uuid=" + instanceUuid + " are overridden by a new distinct set of addresses: " + linkedAddresses + ". We expect to see this log only when persistence is enabled where a new member restarts with the same member uuid by picking up different addresses for itself AND where some stale connections to the old shutdown member having the same uuid, is not closed yet on this member.");
                }
            }
            linkedAddresses.getAllAddresses().forEach(address -> {
                UUID oldMemberUuid = (UUID)this.addressToUuid.get(address);
                if (oldMemberUuid != null && !oldMemberUuid.equals(instanceUuid)) {
                    this.logger.warning("Address: " + address + " is previously registered with the member uuid: " + oldMemberUuid + " to our addressToMemberUuid map, now registered with/overridden by a new member uuid: " + instanceUuid + ". In the case, the overridden member uuid belongs to an old member that is recently restarted, this override is expected and it does not create any harm as it will delete the entry of old stale connections. But, if you use the intersecting set of addresses in the two different members in your cluster topology, please use the different set of addresses in the connected members. Tip: We can encounter members using these same addresses in WAN setups including clusters that belong to two private networks. If you want only the WAN addresses of the target cluster to be registered, use advanced networking in the both clusters, configure your wan server sockets and your wan publishers with some wan endpoint config.");
                }
                this.addressToUuid.put((Address)address, instanceUuid);
            });
            if (this.logger.isFineEnabled()) {
                this.logger.fine(linkedAddresses + " registered for the instance uuid=" + instanceUuid + " currently all registered addresses for this instance uuid: " + linkedAddressesRegistrationCountPair.getAddresses());
            }
            return linkedAddressesRegistrationCountPair;
        });
    }

    public void tryRemoveRegistration(@Nonnull UUID instanceUuid, @Nonnull Address primaryAddress) {
        this.uuidToAddresses.computeIfPresent(instanceUuid, (uuid, linkedAddressesRegistrationCountPair) -> {
            AtomicInteger registrationCount;
            LinkedAddresses addresses = linkedAddressesRegistrationCountPair.getAddresses();
            if (addresses.contains(primaryAddress) && (registrationCount = linkedAddressesRegistrationCountPair.getRegistrationCount()).decrementAndGet() == 0) {
                Iterator iterator = this.addressToUuid.values().iterator();
                while (iterator.hasNext()) {
                    UUID currUuid = (UUID)iterator.next();
                    if (!currUuid.equals(instanceUuid)) continue;
                    iterator.remove();
                }
                if (this.logger.isFineEnabled()) {
                    this.logger.fine(addresses + " previously registered for the instance uuid=" + instanceUuid + " are removed from the registry");
                }
                return null;
            }
            return linkedAddressesRegistrationCountPair;
        });
    }

    @Nullable
    public UUID uuidOf(@Nonnull Address address) {
        if (this.localAddresses != null && this.localAddresses.contains(address)) {
            return this.localUuid;
        }
        return (UUID)this.addressToUuid.get(address);
    }

    @Nullable
    public LinkedAddresses linkedAddressesOf(@Nonnull UUID uuid) {
        if (uuid.equals(this.localUuid)) {
            return this.localAddresses;
        }
        Pair pair = (Pair)this.uuidToAddresses.get(uuid);
        return pair != null ? pair.getAddresses() : null;
    }

    @Nullable
    public Address getPrimaryAddress(@Nonnull UUID uuid) {
        if (uuid.equals(this.localUuid)) {
            return this.localAddresses.getPrimaryAddress();
        }
        LinkedAddresses linkedAddresses = this.linkedAddressesOf(uuid);
        return linkedAddresses != null ? linkedAddresses.getPrimaryAddress() : null;
    }

    public void reset() {
        this.addressToUuid.clear();
        this.uuidToAddresses.clear();
    }

    public void setLocalUuid(@Nonnull UUID newUuid) {
        this.localUuid = newUuid;
    }

    @Nonnull
    public Set<Address> getLocalAddresses() {
        return this.localAddresses.getAllAddresses();
    }

    private void registerLocalAddresses(UUID thisUuid, AddressPicker addressPicker) {
        LinkedAddresses addresses = LinkedAddresses.getResolvedAddresses(addressPicker.getPublicAddress(EndpointQualifier.MEMBER));
        for (Map.Entry<EndpointQualifier, Address> addressEntry : addressPicker.getBindAddressMap().entrySet()) {
            addresses.addAllResolvedAddresses(addressPicker.getPublicAddress(addressEntry.getKey()));
            addresses.addAllResolvedAddresses(addressEntry.getValue());
            ServerSocketChannel serverSocketChannel = addressPicker.getServerSocketChannel(addressEntry.getKey());
            if (serverSocketChannel != null && serverSocketChannel.socket().getInetAddress().isAnyLocalAddress()) {
                int port = addressEntry.getValue().getPort();
                try {
                    Collections.list(NetworkInterface.getNetworkInterfaces()).forEach(networkInterface -> Collections.list(networkInterface.getInetAddresses()).forEach(inetAddress -> addresses.addAllResolvedAddresses(new Address((InetAddress)inetAddress, port))));
                }
                catch (SocketException e) {
                    EmptyStatement.ignore(e);
                }
            }
            this.localUuid = thisUuid;
            this.localAddresses = addresses;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine(this.localAddresses + " are registered for the local member with local uuid=" + this.localUuid);
        }
    }

    private static final class Pair {
        private final LinkedAddresses addresses;
        private final AtomicInteger registrationCount;

        private Pair(LinkedAddresses addresses, AtomicInteger connectionCount) {
            this.addresses = addresses;
            this.registrationCount = connectionCount;
        }

        public LinkedAddresses getAddresses() {
            return this.addresses;
        }

        public AtomicInteger getRegistrationCount() {
            return this.registrationCount;
        }
    }
}

