/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace.impl;

import com.hazelcast.spi.impl.NodeEngine;

public final class NodeEngineThreadLocalContext {
    private static final ThreadLocal<NodeEngine> NE_THREAD_LOCAL = new ThreadLocal();

    private NodeEngineThreadLocalContext() {
    }

    public static void declareNodeEngineReference(NodeEngine nodeEngine) {
        if (nodeEngine != null) {
            NE_THREAD_LOCAL.set(nodeEngine);
        }
    }

    public static void destroyNodeEngineReference() {
        NE_THREAD_LOCAL.remove();
    }

    public static NodeEngine getNodeEngineThreadLocalContext() {
        NodeEngine tlContext = NE_THREAD_LOCAL.get();
        if (tlContext == null) {
            throw new IllegalStateException("NodeEngine context is not available for Namespaces! Current thread: " + Thread.currentThread().getName() + " (" + Thread.currentThread().getId() + ")");
        }
        return tlContext;
    }

    public static NodeEngine getNodeEngineThreadLocalContextOrNull() {
        NodeEngine tlContext = NE_THREAD_LOCAL.get();
        if (tlContext == null) {
            return null;
        }
        return tlContext;
    }
}

