/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.management.MCClusterMetadata;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCGetClusterMetadataCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.security.permission.ManagementPermission;
import java.security.Permission;

public class GetClusterMetadataMessageTask
extends AbstractCallableMessageTask<Void> {
    private static final Permission REQUIRED_PERMISSION = new ManagementPermission("cluster.getMetadata");

    public GetClusterMetadataMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        MCClusterMetadata metadata = new MCClusterMetadata();
        metadata.setCurrentState(this.nodeEngine.getClusterService().getClusterState());
        metadata.setMemberVersion(BuildInfoProvider.getBuildInfo().getVersion());
        metadata.setClusterTime(this.nodeEngine.getClusterService().getClusterTime());
        metadata.setClusterId(this.nodeEngine.getClusterService().getClusterId());
        return metadata;
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        MCClusterMetadata metadata = (MCClusterMetadata)response;
        return MCGetClusterMetadataCodec.encodeResponse(metadata.getCurrentState().getId(), metadata.getMemberVersion(), null, metadata.getClusterTime(), metadata.getClusterId());
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return REQUIRED_PERMISSION;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getClusterMetadata";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

