/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.gui;

import com.izforge.izpack.gui.MultiLineLabel;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LabelFactory
implements SwingConstants {
    private static boolean useLabelIcons = true;
    private static float labelFontSizeVal = 1.0f;
    private static Font customLabelFontObj = null;

    public static boolean isUseLabelIcons() {
        return useLabelIcons;
    }

    public static void setUseLabelIcons(boolean useLabelIcons) {
        LabelFactory.useLabelIcons = useLabelIcons;
    }

    public static float getLabelFontSize() {
        return labelFontSizeVal;
    }

    public static void setLabelFontSize(float val) {
        if (val > 0.0f && val <= 5.0f && val != labelFontSizeVal) {
            labelFontSizeVal = val;
            Font fontObj = new JLabel().getFont();
            customLabelFontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
    }

    public static JLabel create(Icon image) {
        return LabelFactory.create(image, 0);
    }

    public static JLabel create(Icon image, int horizontalAlignment) {
        return LabelFactory.create(null, image, horizontalAlignment);
    }

    public static JLabel create(String text) {
        return LabelFactory.create(text, 0);
    }

    public static JLabel create(String text, boolean isFullLine) {
        return LabelFactory.create(text, 0, isFullLine);
    }

    public static JLabel create(String text, int horizontalAlignment) {
        return LabelFactory.create(text, null, horizontalAlignment);
    }

    public static JLabel create(String text, int horizontalAlignment, boolean isFullLine) {
        return LabelFactory.create(text, null, horizontalAlignment, isFullLine);
    }

    public static JLabel create(String text, Icon image, int horizontalAlignment) {
        return LabelFactory.create(text, image, horizontalAlignment, false);
    }

    public static JLabel create(String text, Icon image, int horizontalAlignment, boolean isFullLine) {
        JLabel retval = image != null && LabelFactory.isUseLabelIcons() ? (isFullLine ? new FullLineLabel(image) : new JLabel(image)) : (isFullLine ? new FullLineLabel() : new JLabel());
        if (text != null) {
            retval.setText(text);
        }
        if (customLabelFontObj != null) {
            retval.setFont(customLabelFontObj);
        }
        retval.setHorizontalAlignment(horizontalAlignment);
        return retval;
    }

    public static Font getControlTextFont() {
        Font fontObj = LabelFactory.getLAF() != null ? MetalLookAndFeel.getControlTextFont() : UIManager.getDefaults().getFont("Label.font");
        float val = LabelFactory.getLabelFontSize();
        if (val != 1.0f) {
            fontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
        return fontObj;
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)lookAndFeel;
        }
        return null;
    }

    public static MultiLineLabel createMultiLineLabel(String text) {
        MultiLineLabel multiLineLabel = new MultiLineLabel(text);
        multiLineLabel.setText(text);
        if (customLabelFontObj != null) {
            multiLineLabel.setFont(customLabelFontObj);
        } else {
            multiLineLabel.setFont(LabelFactory.getControlTextFont());
        }
        return multiLineLabel;
    }

    public static class FullLineLabel
    extends JLabel {
        private static final long serialVersionUID = 2918265795390777147L;

        public FullLineLabel(Icon image) {
            super(image);
        }

        public FullLineLabel() {
        }
    }
}

