/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.api.exception;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class NativeLibException
extends Exception {
    private static final long serialVersionUID = 3257002172494721080L;
    private static final HashMap<String, ResourceBundle> messageResourceBundles = new HashMap();
    private int libErr;
    private int osErr;
    private String libErrString;
    private String osErrString;
    private ArrayList<String> args = new ArrayList();

    public static void addResourceBundle(String bundlePath) {
        ResourceBundle resourceBundle = null;
        if (messageResourceBundles.containsKey(bundlePath)) {
            return;
        }
        try {
            resourceBundle = ResourceBundle.getBundle(bundlePath);
        }
        catch (MissingResourceException mre) {
            mre.printStackTrace();
        }
        messageResourceBundles.put(bundlePath, resourceBundle);
    }

    public NativeLibException() {
    }

    public NativeLibException(String message) {
        super(message);
    }

    public NativeLibException(Throwable cause) {
        super(cause);
    }

    public NativeLibException(String message, Throwable cause) {
        super(message, cause);
    }

    public NativeLibException(int libErr, int osErr, String libString, String osString) {
        this.libErr = libErr;
        this.osErr = osErr;
        this.libErrString = libString;
        this.osErrString = osString;
    }

    @Override
    public String getMessage() {
        StringBuffer retval = new StringBuffer();
        boolean next = false;
        if (this.libErrString != null) {
            retval.append(this.getLocalizedLibMessage());
            next = true;
        } else if (this.libErr != 0) {
            if (next) {
                retval.append("\n");
            }
            next = true;
            retval.append(this.getMsg("libErrNumber." + Integer.toString(this.libErr)));
        }
        if (this.osErr != 0) {
            if (next) {
                retval.append("\n");
            }
            next = true;
            retval.append(this.getMsg("libInternal.OsErrNumPraefix")).append(Integer.toString(this.osErr));
        }
        if (this.osErrString != null) {
            if (next) {
                retval.append("\n");
            }
            next = true;
            retval.append(this.getMsg("libInternal.OsErrStringPraefix")).append(this.getOsMessage());
        }
        if (retval.length() > 0) {
            return this.reviseMsgWithArgs(retval.toString());
        }
        return null;
    }

    public int getLibErr() {
        return this.libErr;
    }

    public String getLibMessage() {
        return this.libErrString;
    }

    public String getLocalizedLibMessage() {
        return this.getMsg(this.libErrString);
    }

    public int getOsErr() {
        return this.osErr;
    }

    public String getOsMessage() {
        return this.osErrString;
    }

    public void addArgument(String arg) {
        this.args.add(arg);
    }

    public ArrayList<String> getArguments() {
        return this.args;
    }

    public String reviseMsgWithArgs(String msg) {
        for (int i = 0; i < this.args.size(); ++i) {
            String key = "{" + Integer.toString(i) + "}";
            msg = NativeLibException.replaceString(msg, key, this.args.get(i));
        }
        return msg;
    }

    private String getMsg(String s) {
        for (ResourceBundle resourceBundle : messageResourceBundles.values()) {
            try {
                return resourceBundle.getString(s);
            }
            catch (MissingResourceException missingResourceException) {
            }
        }
        return s;
    }

    private static String replaceString(String destination, String what, String with) {
        if (destination.contains(what)) {
            StringBuffer buf = new StringBuffer();
            int last = 0;
            int current = destination.indexOf(what);
            int whatLength = what.length();
            while (current >= 0) {
                if (current > 0) {
                    buf.append(destination.substring(last, current));
                }
                buf.append(with);
                last = current + whatLength;
                current = destination.indexOf(what, last);
            }
            if (destination.length() > last) {
                buf.append(destination.substring(last));
            }
            return buf.toString();
        }
        return destination;
    }

    static {
        NativeLibException.addResourceBundle("com.coi.tools.os.win.resources.NativeLibErr");
    }
}

