/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.transport;

import java.util.HashMap;
import java.util.Map;
import net.messagevortex.transport.Credentials;
import net.messagevortex.transport.imap.ImapConnection;

public class AuthenticationProxy {
    private ImapConnection conn = null;
    private final Map<String, Credentials> users = new HashMap<String, Credentials>();

    public ImapConnection setImapConnection(ImapConnection conn) {
        ImapConnection oc = this.conn;
        this.conn = conn;
        return oc;
    }

    public ImapConnection getImapConnection() {
        return this.conn;
    }

    public void addUser(String username, String password) {
        this.users.put(username.toLowerCase(), new Credentials(username, password));
    }

    public void addCredentials(Credentials creds) {
        this.users.put(creds.getUsername().toLowerCase(), creds);
    }

    public boolean login(String username, String password) {
        if (username == null || password == null) {
            return false;
        }
        if (this.users.get(username.toLowerCase()) == null) {
            return false;
        }
        return this.users.get(username.toLowerCase()).getPassword().equals(password);
    }

    public Credentials getCredentials(String authzid) {
        return this.users.get(authzid);
    }
}

