/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.router.operation.AbstractOperation;

public class IdMapOperation
extends AbstractOperation
implements Serializable {
    public static final long serialVersionUID = 100000000019L;
    private static final transient Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    private final int[] outputId;
    private final int[] inputId;

    public IdMapOperation(int sourceId, int targetId, int number) {
        this.inputId = new int[number];
        this.outputId = new int[number];
        for (int i = 0; i < this.inputId.length; ++i) {
            this.inputId[i] = sourceId + i;
            this.outputId[i] = targetId + i;
        }
    }

    @Override
    public int[] getOutputId() {
        return (int[])this.outputId.clone();
    }

    @Override
    public int[] getInputId() {
        return (int[])this.inputId.clone();
    }

    @Override
    public boolean canRun() {
        return true;
    }

    @Override
    public int[] execute(int[] id) {
        LOGGER.log(Level.INFO, "running IDMapper " + this.inputId[0] + "/" + this.outputId[0] + "/" + this.inputId.length);
        for (int i = 0; i < this.inputId.length; ++i) {
            this.payload.setCalculatedPayload(this.outputId[i], this.payload.getPayload(this.inputId[i]));
        }
        return this.getOutputId();
    }

    public String toString() {
        return this.inputId[0] + "->IdMapper(" + this.inputId.length + ")->" + this.outputId[0];
    }
}

