/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.generic;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.apache.velocity.tools.ClassUtils;
import org.apache.velocity.tools.ConversionUtils;
import org.apache.velocity.tools.config.InvalidScope;
import org.apache.velocity.tools.generic.SafeConfig;
import org.apache.velocity.tools.generic.ValueParser;

@InvalidScope(value={"application", "session", "request"})
public class ImportSupport
extends SafeConfig {
    protected static final String VALID_SCHEME_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+.-";
    public static final String RESOURCE_KEY = "resource";
    public static final String URL_KEY = "url";

    @Override
    protected void configure(ValueParser values) {
        super.configure(values);
    }

    @Override
    public void setSafeMode(boolean safe) {
        super.setSafeMode(safe);
    }

    public String acquireString(String url) throws IOException {
        this.getLog().debug("acquire URL {}", (Object)url);
        if (ImportSupport.isRemoteURL(url)) {
            return this.acquireRemoteURLString(url);
        }
        return this.acquireLocalURLString(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String acquireRemoteURLString(String url) throws IOException {
        BufferedReader r = null;
        try {
            int i2;
            r = new BufferedReader(this.acquireRemoteURLReader(url));
            StringBuilder sb = new StringBuilder();
            while ((i2 = r.read()) != -1) {
                sb.append((char)i2);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    this.getLog().error("Could not close reader.", ioe);
                }
            }
        }
    }

    protected String acquireLocalURLString(String url) throws IOException {
        throw new IOException("Only remote URLs are supported");
    }

    public Reader acquireReader(String url) throws IOException {
        this.getLog().debug("acquire URL {}", (Object)url);
        if (ImportSupport.isRemoteURL(url)) {
            return this.acquireRemoteURLReader(url);
        }
        return this.acquireLocalURLReader(url);
    }

    protected Reader acquireRemoteURLReader(String url) throws IOException {
        URLConnection uc = null;
        HttpURLConnection huc = null;
        InputStream i2 = null;
        try {
            String charSet;
            int status;
            URL u = ConversionUtils.toURL(url);
            uc = u.openConnection();
            i2 = uc.getInputStream();
            if (uc instanceof HttpURLConnection && ((status = (huc = (HttpURLConnection)uc).getResponseCode()) < 200 || status > 299)) {
                throw new IOException(status + " " + url);
            }
            InputStreamReader r = null;
            String contentType = uc.getContentType();
            if (contentType != null) {
                charSet = ImportSupport.getContentTypeAttribute(contentType, "charset");
                if (charSet == null) {
                    charSet = "UTF-8";
                }
            } else {
                charSet = "UTF-8";
            }
            try {
                r = new InputStreamReader(i2, charSet);
            }
            catch (UnsupportedEncodingException ueex) {
                r = new InputStreamReader(i2, "UTF-8");
            }
            if (huc == null) {
                return r;
            }
            return new SafeClosingHttpURLConnectionReader(r, huc);
        }
        catch (IOException ex) {
            if (i2 != null) {
                try {
                    i2.close();
                }
                catch (IOException ioe) {
                    this.getLog().error("Could not close InputStream", ioe);
                }
            }
            if (huc != null) {
                huc.disconnect();
            }
            throw new IOException("Problem accessing the remote URL \"" + url + "\". " + ex);
        }
        catch (RuntimeException ex) {
            if (i2 != null) {
                try {
                    i2.close();
                }
                catch (IOException ioe) {
                    this.getLog().error("Could not close InputStream", ioe);
                }
            }
            if (huc != null) {
                huc.disconnect();
            }
            throw new IOException("Problem accessing the remote URL \"" + url + "\" :" + ex.getMessage(), ex);
        }
    }

    protected Reader acquireLocalURLReader(String url) throws IOException {
        throw new IOException("Only remote URLs are supported");
    }

    public static boolean isRemoteURL(String url) {
        return ImportSupport.getProtocol(url) != null;
    }

    public static String getProtocol(String url) {
        if (url == null) {
            return null;
        }
        int colonPos = url.indexOf(58);
        if (colonPos == -1) {
            return null;
        }
        for (int i2 = 0; i2 < colonPos; ++i2) {
            if (VALID_SCHEME_CHARS.indexOf(url.charAt(i2)) != -1) continue;
            return null;
        }
        return url.substring(0, colonPos);
    }

    public static String getContentTypeAttribute(String input, String name) {
        int end;
        int begin;
        int index = input.toUpperCase().indexOf(name.toUpperCase());
        if (index == -1) {
            return null;
        }
        index += name.length();
        if ((index = input.indexOf(61, index)) == -1) {
            return null;
        }
        if ((input = input.substring(++index).trim()).charAt(0) == '\"') {
            begin = 1;
            end = input.indexOf(34, begin);
            if (end == -1) {
                return null;
            }
        } else {
            begin = 0;
            end = input.indexOf(59);
            if (end == -1) {
                end = input.indexOf(32);
            }
            if (end == -1) {
                end = input.length();
            }
        }
        return input.substring(begin, end).trim();
    }

    public String getResourceString(String resource) {
        String ret = null;
        try {
            Reader rawReader = this.getResourceReader(resource);
            if (rawReader != null) {
                int i2;
                BufferedReader reader = new BufferedReader(rawReader);
                StringBuilder sb = new StringBuilder();
                while ((i2 = reader.read()) != -1) {
                    sb.append((char)i2);
                }
                ret = sb.toString();
            }
        }
        catch (IOException ioe) {
            this.getLog().error("could not load resource {}", (Object)resource, (Object)ioe);
        }
        return ret;
    }

    public Reader getResourceReader(String resource) {
        this.getLog().debug("get resource {}", (Object)resource);
        URL url = null;
        InputStreamReader reader = null;
        try {
            url = this.getFileResource(resource);
            if (url == null) {
                url = this.getClasspathResource(resource);
            }
            if (url != null) {
                String charSet;
                URLConnection uc = url.openConnection();
                InputStream is = uc.getInputStream();
                String contentType = uc.getContentType();
                if (contentType != null) {
                    charSet = ImportSupport.getContentTypeAttribute(contentType, "charset");
                    if (charSet == null) {
                        charSet = "UTF-8";
                    }
                } else {
                    charSet = "UTF-8";
                }
                reader = new InputStreamReader(is, charSet);
            }
        }
        catch (Exception e) {
            this.getLog().error("could not get resource {}", (Object)resource, (Object)e);
        }
        return reader;
    }

    protected URL getFileResource(String resource) throws Exception {
        URL url = null;
        File file = new File(resource);
        if (file.exists() && file.isFile() && file.canRead()) {
            url = file.toURI().toURL();
        }
        return url;
    }

    protected URL getClasspathResource(String resource) throws Exception {
        return ClassUtils.getResource(resource, this);
    }

    protected static class SafeClosingHttpURLConnectionReader
    extends Reader {
        private final HttpURLConnection huc;
        private final Reader wrappedReader;

        SafeClosingHttpURLConnectionReader(Reader r, HttpURLConnection huc) {
            this.wrappedReader = r;
            this.huc = huc;
        }

        @Override
        public void close() throws IOException {
            if (null != this.huc) {
                this.huc.disconnect();
            }
            this.wrappedReader.close();
        }

        @Override
        public void mark(int readAheadLimit) throws IOException {
            this.wrappedReader.mark(readAheadLimit);
        }

        @Override
        public boolean markSupported() {
            return this.wrappedReader.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.wrappedReader.read();
        }

        @Override
        public int read(char[] buf) throws IOException {
            return this.wrappedReader.read(buf);
        }

        @Override
        public int read(char[] buf, int off, int len) throws IOException {
            return this.wrappedReader.read(buf, off, len);
        }

        @Override
        public boolean ready() throws IOException {
            return this.wrappedReader.ready();
        }

        @Override
        public void reset() throws IOException {
            this.wrappedReader.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrappedReader.skip(n);
        }
    }
}

