/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.status;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.util.AbstractConsumer;

public class SvnStatusConsumer
extends AbstractConsumer {
    private final File workingDirectory;
    private final List<ScmFile> changedFiles = new ArrayList<ScmFile>();

    public SvnStatusConsumer(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void consumeLine(String line) {
        ScmFileStatus status;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(line);
        }
        if (line.trim().isEmpty()) {
            return;
        }
        if (line.length() <= 7) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Unexpected input, the line must be at least seven characters long. Line: '" + line + "'.");
            }
            return;
        }
        String statusString = line.substring(0, 1);
        String file = line.substring(7).trim();
        if (statusString.equals("A")) {
            status = ScmFileStatus.ADDED;
        } else if (statusString.equals("M") || statusString.equals("R") || statusString.equals("~")) {
            status = ScmFileStatus.MODIFIED;
        } else if (statusString.equals("D")) {
            status = ScmFileStatus.DELETED;
        } else if (statusString.equals("?")) {
            status = ScmFileStatus.UNKNOWN;
        } else if (statusString.equals("!")) {
            status = ScmFileStatus.MISSING;
        } else if (statusString.equals("C")) {
            status = ScmFileStatus.CONFLICT;
        } else if (statusString.equals("L")) {
            status = ScmFileStatus.LOCKED;
        } else {
            if (statusString.equals("X")) {
                return;
            }
            if (statusString.equals("I")) {
                return;
            }
            statusString = line.substring(1, 1);
            return;
        }
        if (!status.equals(ScmFileStatus.DELETED) && !new File(this.workingDirectory, file).isFile()) {
            return;
        }
        this.changedFiles.add(new ScmFile(file, status));
    }

    public List<ScmFile> getChangedFiles() {
        return this.changedFiles;
    }
}

