/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GitConfigFileReader {
    private File configDirectory;

    public File getConfigDirectory() {
        if (this.configDirectory == null) {
            File confDir = new File(".git");
            if (confDir.exists()) {
                this.configDirectory = confDir;
            } else {
                confDir = new File(".");
                if (confDir.exists()) {
                    this.configDirectory = confDir;
                }
            }
        }
        return this.configDirectory;
    }

    public void setConfigDirectory(File configDirectory) {
        this.configDirectory = configDirectory;
    }

    public String getProperty(String group, String propertyName) {
        List<String> lines = this.getConfLines();
        boolean inGroup = false;
        Iterator<String> i2 = lines.iterator();
        while (i2.hasNext()) {
            String property;
            String line = i2.next().trim();
            if (!inGroup) {
                if (!("[" + group + "]").equals(line)) continue;
                inGroup = true;
                continue;
            }
            if (line.startsWith("[") && line.endsWith("]")) {
                return null;
            }
            if (line.startsWith("#") || line.indexOf(61) < 0 || !(property = line.substring(0, line.indexOf(61)).trim()).equals(propertyName)) continue;
            String value = line.substring(line.indexOf(61) + 1);
            return value.trim();
        }
        return null;
    }

    private List<String> getConfLines() {
        ArrayList<String> lines;
        block15: {
            lines = new ArrayList<String>();
            try {
                if (!this.getConfigDirectory().exists()) break block15;
                try (BufferedReader reader = new BufferedReader(new FileReader(new File(this.getConfigDirectory(), "config")));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith("#") || line == null || line.isEmpty()) continue;
                        lines.add(line);
                    }
                }
            }
            catch (IOException e) {
                lines.clear();
            }
        }
        return lines;
    }
}

