/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.MailingList;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.report.projectinfo.AbstractProjectInfoRenderer;
import org.apache.maven.report.projectinfo.AbstractProjectInfoReport;
import org.apache.maven.report.projectinfo.ProjectInfoReportUtils;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.i18n.I18N;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="mailing-lists")
public class MailingListsReport
extends AbstractProjectInfoReport {
    @Inject
    public MailingListsReport(RepositorySystem repositorySystem, I18N i18n, ProjectBuilder projectBuilder) {
        super(repositorySystem, i18n, projectBuilder);
    }

    @Override
    public boolean canGenerateReport() throws MavenReportException {
        boolean result = super.canGenerateReport();
        if (result && this.skipEmptyReport) {
            result = !this.isEmpty(this.getProject().getModel().getMailingLists());
        }
        return result;
    }

    @Override
    public void executeReport(Locale locale) {
        MailingListsRenderer r = new MailingListsRenderer(this.getLog(), this.getSink(), this.getProject().getModel(), this.getI18N(locale), locale);
        r.render();
    }

    @Override
    public String getOutputName() {
        return "mailing-lists";
    }

    @Override
    protected String getI18Nsection() {
        return "mailing-lists";
    }

    protected static class MailingListsRenderer
    extends AbstractProjectInfoRenderer {
        private final Log log;
        private final Model model;

        MailingListsRenderer(Log log, Sink sink, Model model, I18N i18n, Locale locale) {
            super(sink, i18n, locale);
            this.model = model;
            this.log = log;
        }

        @Override
        protected String getI18Nsection() {
            return "mailing-lists";
        }

        @Override
        protected void renderBody() {
            List<MailingList> mailingLists = this.model.getMailingLists();
            if (mailingLists == null || mailingLists.isEmpty()) {
                this.startSection(this.getTitle());
                this.paragraph(this.getI18nString("nolist"));
                this.endSection();
                return;
            }
            this.startSection(this.getTitle());
            this.paragraph(this.getI18nString("intro"));
            this.startTable();
            boolean otherArchives = false;
            for (MailingList m : mailingLists) {
                if (m.getOtherArchives() == null || m.getOtherArchives().isEmpty()) continue;
                otherArchives = true;
            }
            String name = this.getI18nString("column.name");
            String subscribe = this.getI18nString("column.subscribe");
            String unsubscribe = this.getI18nString("column.unsubscribe");
            String post = this.getI18nString("column.post");
            String archive = this.getI18nString("column.archive");
            String archivesOther = this.getI18nString("column.otherArchives");
            if (otherArchives) {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive, archivesOther});
            } else {
                this.tableHeader(new String[]{name, subscribe, unsubscribe, post, archive});
            }
            for (MailingList mailingList : this.model.getMailingLists()) {
                ArrayList<String> textRow = new ArrayList<String>();
                if (StringUtils.isNotEmpty(mailingList.getName())) {
                    textRow.add(mailingList.getName());
                } else {
                    textRow.add("-");
                }
                if (StringUtils.isNotEmpty(mailingList.getSubscribe())) {
                    textRow.add(this.createURILinkPatternedText(subscribe, mailingList.getSubscribe(), null));
                } else {
                    textRow.add("-");
                }
                if (StringUtils.isNotEmpty(mailingList.getUnsubscribe())) {
                    textRow.add(this.createURILinkPatternedText(unsubscribe, mailingList.getUnsubscribe(), null));
                } else {
                    textRow.add("-");
                }
                if (StringUtils.isNotEmpty(mailingList.getPost())) {
                    textRow.add(this.createURILinkPatternedText(post, mailingList.getPost(), null));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getArchive() != null && !mailingList.getArchive().isEmpty()) {
                    textRow.add(MailingListsRenderer.createLinkPatternedText(ProjectInfoReportUtils.getArchiveServer(mailingList.getArchive()), mailingList.getArchive()));
                } else {
                    textRow.add("-");
                }
                if (mailingList.getOtherArchives() != null && !mailingList.getOtherArchives().isEmpty()) {
                    Iterator<String> it = mailingList.getOtherArchives().iterator();
                    String otherArchive = it.next();
                    textRow.add(MailingListsRenderer.createLinkPatternedText(ProjectInfoReportUtils.getArchiveServer(otherArchive), otherArchive));
                    this.tableRow(textRow.toArray(new String[textRow.size()]));
                    while (it.hasNext()) {
                        otherArchive = it.next();
                        textRow = new ArrayList();
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(" ");
                        textRow.add(MailingListsRenderer.createLinkPatternedText(ProjectInfoReportUtils.getArchiveServer(otherArchive), otherArchive));
                        this.tableRow(textRow.toArray(new String[textRow.size()]));
                    }
                    continue;
                }
                if (otherArchives) {
                    textRow.add(null);
                }
                this.tableRow(textRow.toArray(new String[textRow.size()]));
            }
            this.endTable();
            this.endSection();
        }

        private String createURILinkPatternedText(String text, String href, String defaultHref) {
            if (href == null || href.isEmpty()) {
                return MailingListsRenderer.createLinkPatternedText(text, defaultHref);
            }
            try {
                URI hrefUri = URI.create(href);
                if (StringUtils.isNotEmpty(hrefUri.getScheme())) {
                    return MailingListsRenderer.createLinkPatternedText(text, href);
                }
                return MailingListsRenderer.createLinkPatternedText(text, "mailto:" + href);
            }
            catch (IllegalArgumentException e) {
                this.log.warn((CharSequence)("Invalid mailing list link provided '" + href + "': " + e.getMessage()));
                return href;
            }
        }
    }
}

