/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3.plugins.strategies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.binder.DigesterLoader;
import org.apache.commons.digester3.plugins.PluginException;
import org.apache.commons.digester3.plugins.RuleLoader;
import org.apache.commons.digester3.xmlrules.FromXmlRulesModule;
import org.apache.commons.logging.Log;
import org.xml.sax.InputSource;

public class LoaderFromStream
extends RuleLoader {
    private final byte[] input;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoaderFromStream(InputStream s) throws Exception {
        try {
            int i2;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[256];
            while ((i2 = s.read(buf)) != -1) {
                baos.write(buf, 0, i2);
            }
            this.input = baos.toByteArray();
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void addRules(Digester d, final String path) throws PluginException {
        Log log = d.getLogger();
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("LoaderFromStream: loading rules for plugin at path [" + path + "]");
        }
        final InputSource source = new InputSource(new ByteArrayInputStream(this.input));
        DigesterLoader.newLoader(new FromXmlRulesModule(){

            protected void loadRules() {
                this.useRootPath(path);
                this.loadXMLRules(source);
            }
        }).createRuleSet().addRuleInstances(d);
    }
}

