/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.NotImplementedException;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.encryption.DumpType;
import picocli.CommandLine;

@CommandLine.Command(description={"dump content of IdentityStore"}, name="dump", aliases={"dp"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerIdentityStoreDump
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--filename", "-f"}, description={"filename of the IdentityStorage file"}, arity="1")
    String filename = "identityStore.cfg";
    @CommandLine.Option(names={"--outputFormat", "-o"}, description={"Format of output"})
    Format outputFormat = Format.ASN1;

    @Override
    public Integer call() throws Exception {
        if (!new File(this.filename).exists()) {
            LOGGER.log(Level.SEVERE, "File \"" + this.filename + "\" not found");
            return 103;
        }
        IdentityStore is = new IdentityStore(new File(this.filename));
        String out = "";
        if (this.outputFormat != Format.ASN1) {
            throw new NotImplementedException();
        }
        out = is.dumpValueNotation("", DumpType.ALL_UNENCRYPTED);
        System.out.println(out);
        return 0;
    }

    static enum Format {
        ASN1,
        YAML;

    }
}

