/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.Serializable;
import net.messagevortex.asn1.HeaderRequest;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;

public class HeaderRequestIncreaseTransferQuota
extends HeaderRequest
implements Serializable {
    public static final long serialVersionUID = 100000000026L;
    private long quota = -1L;

    public HeaderRequestIncreaseTransferQuota() {
    }

    public HeaderRequestIncreaseTransferQuota(ASN1Encodable ae) {
        this();
        if (ae != null) {
            this.parse(ae);
        }
    }

    @Override
    protected final void parse(ASN1Encodable ae) {
        ASN1Sequence s1 = ASN1Sequence.getInstance(ae);
        this.quota = ASN1Integer.getInstance(s1.getObjectAt(0)).getValue().intValue();
    }

    @Override
    protected HeaderRequest getRequest(ASN1Encodable ae) {
        return new HeaderRequestIncreaseTransferQuota(ae);
    }

    public long getQuota() {
        return this.quota;
    }

    public long setQuota(long newQuota) {
        long old = this.quota;
        this.quota = newQuota;
        return old;
    }

    public int getId() {
        return 0;
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumpType) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\r\n");
        if (this.quota > -1L) {
            sb.append(prefix).append("  quota ").append(this.quota).append("\r\n");
        }
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    ASN1Object intToAsn1Object(DumpType dumpType) {
        ASN1EncodableVector s1 = new ASN1EncodableVector();
        s1.add(new ASN1Integer(this.quota));
        return new DERSequence(s1);
    }
}

