/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.vector.impl;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.vector.VectorDocument;
import com.hazelcast.vector.VectorValues;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DataVectorDocument
implements VectorDocument<Data>,
IdentifiedDataSerializable {
    private Data userValue;
    private VectorValues vectorValues;

    public DataVectorDocument() {
    }

    public DataVectorDocument(@Nonnull Data userValue, @Nonnull VectorValues vectorValues) {
        this.userValue = Objects.requireNonNull(userValue, "userValue cannot be null");
        this.vectorValues = Objects.requireNonNull(vectorValues, "vectorValues cannot be null");
    }

    @Override
    @Nonnull
    public Data getValue() {
        return this.userValue;
    }

    @Override
    @Nonnull
    public VectorValues getVectors() {
        return this.vectorValues;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        IOUtil.writeData(out, this.userValue);
        out.writeObject(this.vectorValues);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.userValue = IOUtil.readData(in);
        this.vectorValues = (VectorValues)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return -100;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataVectorDocument that = (DataVectorDocument)o;
        return Objects.equals(this.userValue, that.userValue) && Objects.equals(this.vectorValues, that.vectorValues);
    }

    public int hashCode() {
        return Objects.hash(this.userValue, this.vectorValues);
    }
}

