/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.eviction.ExpiredKey;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class EvictBatchBackupOperation
extends MapOperation
implements BackupOperation {
    private int primaryEntryCount;
    private String name;
    private Collection<ExpiredKey> expiredKeys;

    public EvictBatchBackupOperation() {
    }

    public EvictBatchBackupOperation(String name, Collection<ExpiredKey> expiredKeys, int primaryEntryCount) {
        super(name);
        assert (name != null);
        this.name = name;
        this.expiredKeys = expiredKeys;
        this.primaryEntryCount = primaryEntryCount;
        this.createRecordStoreOnDemand = false;
    }

    @Override
    protected void runInternal() {
        if (this.recordStore == null) {
            return;
        }
        for (ExpiredKey expiredKey : this.expiredKeys) {
            Data key = expiredKey.getKey();
            Object existingRecord = this.recordStore.getRecord(key);
            if (!this.hasSameValueHashCode((Record)existingRecord, expiredKey)) continue;
            this.recordStore.evict(key, true);
        }
        this.equalizeEntryCountWithPrimary();
    }

    public boolean hasSameValueHashCode(Record existingRecord, ExpiredKey expiredKey) {
        if (existingRecord == null) {
            return false;
        }
        return (long)existingRecord.getValue().hashCode() == expiredKey.getMetadata();
    }

    private void equalizeEntryCountWithPrimary() {
        int diff = this.recordStore.size() - this.primaryEntryCount;
        if (diff <= 0) {
            return;
        }
        this.recordStore.sampleAndForceRemoveEntries(diff);
        assert (this.recordStore.size() == this.primaryEntryCount) : String.format("Failed to remove %d entries while attempting to match primary entry count %d, recordStore size is now %d", diff, this.primaryEntryCount, this.recordStore.size());
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        WrongTargetException exception;
        if (throwable instanceof WrongTargetException && (exception = (WrongTargetException)throwable).getTarget() == null) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public int getClassId() {
        return 129;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.name);
        out.writeInt(this.expiredKeys.size());
        for (ExpiredKey expiredKey : this.expiredKeys) {
            IOUtil.writeData(out, expiredKey.getKey());
            out.writeLong(expiredKey.getMetadata());
        }
        out.writeInt(this.primaryEntryCount);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readString();
        int size = in.readInt();
        this.expiredKeys = new LinkedList<ExpiredKey>();
        for (int i2 = 0; i2 < size; ++i2) {
            this.expiredKeys.add(new ExpiredKey(IOUtil.readData(in), in.readLong()));
        }
        this.primaryEntryCount = in.readInt();
    }
}

