/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;

public class AddIndexBackupOperation
extends MapOperation
implements BackupOperation,
AllowedDuringPassiveState {
    private IndexConfig config;

    public AddIndexBackupOperation() {
    }

    public AddIndexBackupOperation(String name, IndexConfig config) {
        super(name);
        this.config = config;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public void runInternal() {
        int partitionId = this.getPartitionId();
        IndexRegistry indexRegistry = this.mapContainer.getOrCreateIndexRegistry(partitionId);
        indexRegistry.recordIndexDefinition(this.config);
        this.mapServiceContext.registerIndex(this.name, this.config);
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.config);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.config = (IndexConfig)in.readObject();
    }

    @Override
    public int getClassId() {
        return 140;
    }
}

