/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.MapSplitBrainHandlerService;
import com.hazelcast.map.impl.operation.MapOperationProvider;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.spi.impl.merge.AbstractMergeRunnable;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;

class MapMergeRunnable
extends AbstractMergeRunnable<Object, Object, RecordStore, SplitBrainMergeTypes.MapMergeTypes<Object, Object>>
implements Disposable {
    private final MapServiceContext mapServiceContext;

    MapMergeRunnable(Collection<RecordStore> mergingStores, MapSplitBrainHandlerService splitBrainHandlerService, MapServiceContext mapServiceContext) {
        super("hz:impl:mapService", mergingStores, splitBrainHandlerService, mapServiceContext.getNodeEngine());
        this.mapServiceContext = mapServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mergeStore(RecordStore store, BiConsumer<Integer, SplitBrainMergeTypes.MapMergeTypes<Object, Object>> consumer) {
        int partitionId = store.getPartitionId();
        store.beforeOperation();
        try {
            store.forEach((key, record) -> {
                Data dataKey = this.toHeapData(key);
                Data dataValue = this.toHeapData(record.getValue());
                ExpiryMetadata expiryMetadata = store.getExpirySystem().getExpiryMetadata(dataKey);
                consumer.accept(partitionId, MergingValueFactory.createMergingEntry((SerializationService)this.getSerializationService(), dataKey, dataValue, record, expiryMetadata));
            }, false);
        }
        finally {
            store.afterOperation();
        }
    }

    @Override
    protected int getBatchSize(String dataStructureName) {
        MapConfig mapConfig = this.getMapConfig(dataStructureName);
        MergePolicyConfig mergePolicyConfig = mapConfig.getMergePolicyConfig();
        return mergePolicyConfig.getBatchSize();
    }

    @Override
    protected SplitBrainMergePolicy getMergePolicy(String dataStructureName) {
        MapConfig mapConfig = this.getMapConfig(dataStructureName);
        MergePolicyConfig mergePolicyConfig = mapConfig.getMergePolicyConfig();
        return this.mergePolicyProvider.getMergePolicy(mergePolicyConfig.getPolicy());
    }

    @Override
    protected String getDataStructureName(RecordStore recordStore) {
        return recordStore.getName();
    }

    @Override
    protected int getPartitionId(RecordStore store) {
        return store.getPartitionId();
    }

    @Override
    protected OperationFactory createMergeOperationFactory(String dataStructureName, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy, int[] partitions, List<SplitBrainMergeTypes.MapMergeTypes<Object, Object>>[] entries) {
        MapOperationProvider operationProvider = this.mapServiceContext.getMapOperationProvider(dataStructureName);
        return operationProvider.createMergeOperationFactory(dataStructureName, partitions, entries, mergePolicy);
    }

    private MapConfig getMapConfig(String dataStructureName) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(dataStructureName);
        return mapContainer.getMapConfig();
    }

    @Override
    public void dispose() {
        Iterator iterator = this.copyOfMergingStores.iterator();
        while (iterator.hasNext()) {
            RecordStore recordStore = (RecordStore)iterator.next();
            recordStore.disposeOnSplitBrainHeal();
            iterator.remove();
        }
    }
}

