/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.execution;

import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.impl.execution.WatermarkCoalescer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class KeyedWatermarkCoalescer {
    private final int queueCount;
    private final Map<Byte, WatermarkCoalescer> coalescers = new HashMap<Byte, WatermarkCoalescer>();
    private final Set<Integer> doneQueues = new HashSet<Integer>();
    private final boolean[] idleQueues;

    KeyedWatermarkCoalescer(int queueCount) {
        this.queueCount = queueCount;
        this.idleQueues = new boolean[queueCount];
    }

    public Set<Byte> keys() {
        return this.coalescers.keySet();
    }

    private WatermarkCoalescer coalescer(byte key) {
        return this.coalescers.computeIfAbsent(key, x -> {
            WatermarkCoalescer wc = WatermarkCoalescer.create(this.queueCount);
            for (Integer queueIndex : this.doneQueues) {
                wc.queueDone(queueIndex);
            }
            for (int i2 = 0; i2 < this.idleQueues.length; ++i2) {
                if (!this.idleQueues[i2]) continue;
                wc.observeWm(i2, Long.MAX_VALUE);
            }
            return wc;
        });
    }

    public List<Watermark> queueDone(int queueIndex) {
        this.doneQueues.add(queueIndex);
        ArrayList<Watermark> result = new ArrayList<Watermark>();
        for (Map.Entry<Byte, WatermarkCoalescer> entry : this.coalescers.entrySet()) {
            long value = entry.getValue().queueDone(queueIndex);
            if (value == Long.MIN_VALUE) continue;
            result.add(new Watermark(value, entry.getKey()));
        }
        return result;
    }

    public void observeEvent(int queueIndex) {
        for (WatermarkCoalescer c : this.coalescers.values()) {
            c.observeEvent(queueIndex);
        }
        this.idleQueues[queueIndex] = false;
    }

    public List<Watermark> observeWm(int queueIndex, Watermark watermark) {
        if (watermark.equals(WatermarkCoalescer.IDLE_MESSAGE)) {
            this.idleQueues[queueIndex] = true;
            boolean allIdle = true;
            for (int i2 = 0; i2 < this.idleQueues.length; ++i2) {
                if (this.doneQueues.contains(i2)) continue;
                allIdle &= this.idleQueues[i2];
            }
            ArrayList<Watermark> watermarks = new ArrayList<Watermark>();
            for (Map.Entry<Byte, WatermarkCoalescer> coalescerEntry : this.coalescers.entrySet()) {
                long observedWm = coalescerEntry.getValue().observeWm(queueIndex, watermark.timestamp());
                assert (observedWm != Long.MAX_VALUE);
                if (observedWm != Long.MIN_VALUE) {
                    watermarks.add(new Watermark(observedWm, coalescerEntry.getKey()));
                }
                assert (coalescerEntry.getValue().idleMessagePending() == allIdle);
            }
            if (allIdle) {
                watermarks.add(WatermarkCoalescer.IDLE_MESSAGE);
            }
            return watermarks;
        }
        this.idleQueues[queueIndex] = false;
        WatermarkCoalescer c = this.coalescer(watermark.key());
        long newWmValue = c.observeWm(queueIndex, watermark.timestamp());
        assert (!c.idleMessagePending());
        if (newWmValue == Long.MIN_VALUE) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new Watermark(newWmValue, watermark.key()));
    }

    public long coalescedWm(byte key) {
        return this.coalescer(key).coalescedWm();
    }

    public long topObservedWm(byte key) {
        return this.coalescer(key).topObservedWm();
    }
}

