/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import java.util.Map;
import java.util.Objects;

public class RemoteMapSourceConfiguration<K, V, T> {
    private final String name;
    private final DataConnectionRef dataConnectionRef;
    private final ClientConfig clientConfig;
    private final Predicate<K, V> predicate;
    private final Projection<? super Map.Entry<K, V>, ? extends T> projection;

    public RemoteMapSourceConfiguration(String name, DataConnectionRef dataConnectionRef, ClientConfig clientConfig, Predicate<K, V> predicate, Projection<? super Map.Entry<K, V>, ? extends T> projection) {
        this.name = Objects.requireNonNull(name);
        this.dataConnectionRef = dataConnectionRef;
        this.clientConfig = clientConfig;
        this.predicate = predicate;
        this.projection = projection;
    }

    public boolean hasPredicate() {
        return this.predicate != null;
    }

    public String getName() {
        return this.name;
    }

    public DataConnectionRef getDataConnectionRef() {
        return this.dataConnectionRef;
    }

    public String getDataConnectionName() {
        return this.dataConnectionRef == null ? null : this.dataConnectionRef.getName();
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public Predicate<K, V> getPredicate() {
        return this.predicate;
    }

    public Projection<? super Map.Entry<K, V>, ? extends T> getProjection() {
        return this.projection;
    }
}

