/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.counters;

import com.hazelcast.internal.util.counters.Counter;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public final class SwCounter
implements Counter {
    private static final VarHandle VALUE;
    private volatile long value;

    private SwCounter(long value) {
        this.value = value;
    }

    public static SwCounter newSwCounter() {
        return SwCounter.newSwCounter(0L);
    }

    public static SwCounter newSwCounter(long initialValue) {
        return new SwCounter(initialValue);
    }

    @Override
    public long inc() {
        long l = VALUE.getOpaque(this) + 1L;
        VALUE.setOpaque(this, l);
        return l;
    }

    @Override
    public long inc(long amount) {
        long l = VALUE.getOpaque(this) + amount;
        VALUE.setOpaque(this, l);
        return l;
    }

    @Override
    public long get() {
        return VALUE.getOpaque(this);
    }

    @Override
    public void set(long newValue) {
        VALUE.setOpaque(this, newValue);
    }

    @Override
    public long getAndSet(long newValue) {
        long oldValue = VALUE.getOpaque(this);
        VALUE.setOpaque(this, newValue);
        return oldValue;
    }

    public String toString() {
        return "Counter{value=" + this.value + "}";
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VALUE = l.findVarHandle(SwCounter.class, "value", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

