/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.partition.impl.PartitionDataSerializerHook;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.UUID;

public final class PartitionReplica
implements IdentifiedDataSerializable {
    private Address address;
    private UUID uuid;

    public PartitionReplica() {
    }

    public PartitionReplica(Address address, UUID uuid) {
        assert (address != null);
        assert (uuid != null);
        this.address = address;
        this.uuid = uuid;
    }

    public Address address() {
        return this.address;
    }

    public UUID uuid() {
        return this.uuid;
    }

    public boolean isIdentical(Member member) {
        return this.address.equals(member.getAddress()) && this.uuid.equals(member.getUuid());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionReplica)) {
            return false;
        }
        PartitionReplica replica = (PartitionReplica)o;
        if (!this.address.equals(replica.address)) {
            return false;
        }
        return this.uuid.equals(replica.uuid);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    public String toString() {
        return "[" + this.address.getHost() + "]:" + this.address.getPort() + " - " + this.uuid;
    }

    @Override
    public int getFactoryId() {
        return PartitionDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 19;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.address);
        UUIDSerializationUtil.writeUUID(out, this.uuid);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = (Address)in.readObject();
        this.uuid = UUIDSerializationUtil.readUUID(in);
    }

    public static PartitionReplica from(Member member) {
        return new PartitionReplica(member.getAddress(), member.getUuid());
    }

    public static PartitionReplica[] from(Member[] members) {
        PartitionReplica[] replicas = new PartitionReplica[members.length];
        for (int i2 = 0; i2 < members.length; ++i2) {
            replicas[i2] = PartitionReplica.from(members[i2]);
        }
        return replicas;
    }
}

