/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.router.operation;

import java.util.Arrays;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.router.operation.MathMode;
import net.messagevortex.router.operation.Matrix;
import net.messagevortex.router.operation.VandermondeMatrix;

public class RedundancyMatrix
extends VandermondeMatrix {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());

    public RedundancyMatrix(RedundancyMatrix r) {
        this(r.dimension[0], r.dimension[1], r.mode, true, true);
        this.matrixContent = Arrays.copyOf(r.matrixContent, r.matrixContent.length);
    }

    public RedundancyMatrix(int dataRows, int total, MathMode mode) {
        this(dataRows, total, mode, true, false);
    }

    public RedundancyMatrix(int dataRows, int total, MathMode mode, boolean noCache, boolean noNormalize) {
        super(dataRows, total, mode);
        if (!matrixCacheDisabled) {
            Matrix m = RedundancyMatrix.getCache("rm" + dataRows + "/" + total + "/" + mode.toString());
            if (!noCache && m != null) {
                m = new Matrix(m);
                this.matrixContent = m.matrixContent;
                return;
            }
        }
        if (!noNormalize) {
            for (int col = 1; col < this.getX(); ++col) {
                if (this.getField(col, col) != 1) {
                    int scalar = this.getField(col, col);
                    this.transformColumn(col, -1, scalar);
                    assert (this.getField(col, col) == 1);
                }
                for (int col2 = 0; col2 < this.getX(); ++col2) {
                    int scalar = this.getField(col2, col);
                    if (col == col2 || scalar == 0) continue;
                    this.transformColumn(col2, col, scalar);
                    assert (this.getField(col2, col) == 0);
                }
            }
            RedundancyMatrix.addCache("rm" + dataRows + "/" + total + "/" + mode.toString(), new Matrix(this));
        }
    }

    public Matrix getRecoveryMatrix(int[] missingRowIndex) {
        RedundancyMatrix red = new RedundancyMatrix(this);
        Arrays.sort(missingRowIndex);
        for (int i = missingRowIndex.length - 1; i >= 0; --i) {
            red.removeRow(missingRowIndex[i]);
        }
        while (red.getX() < red.getY()) {
            red.removeRow(red.getY() - 1);
        }
        return red.getInverse();
    }
}

