/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.commandline;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.messagevortex.MessageVortexLogger;
import net.messagevortex.asn1.IdentityStore;
import net.messagevortex.asn1.encryption.DumpType;
import picocli.CommandLine;

@CommandLine.Command(description={"Create an empty IdentityStore"}, name="create", aliases={"cr"}, mixinStandardHelpOptions=true)
public class CommandLineHandlerIdentityStoreCreate
implements Callable<Integer> {
    private static final Logger LOGGER = MessageVortexLogger.getLogger(new Throwable().getStackTrace()[0].getClassName());
    @CommandLine.Option(names={"--filename", "-f"}, description={"filename of the IdentityStorage file"})
    String filename = "identityStore.cfg";

    @Override
    public Integer call() throws Exception {
        IdentityStore is = new IdentityStore();
        if (new File(this.filename).exists()) {
            LOGGER.log(Level.SEVERE, "File \"" + this.filename + "\" already exists");
            return 103;
        }
        LOGGER.log(Level.INFO, "Writing \"" + this.filename + "\"");
        try (OutputStream os = Files.newOutputStream(Paths.get(this.filename, new String[0]), new OpenOption[0]);){
            os.write(is.toBytes(DumpType.ALL_UNENCRYPTED));
        }
        LOGGER.log(Level.INFO, "Finished");
        return 0;
    }
}

