/*
 * Decompiled with CFR 0.152.
 */
package net.messagevortex.asn1;

import java.io.IOException;
import java.io.Serializable;
import net.messagevortex.asn1.AbstractBlock;
import net.messagevortex.asn1.encryption.DumpType;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class SizeBlock
extends AbstractBlock
implements Serializable {
    public static final long serialVersionUID = 100000000015L;
    SizeType type;
    int from;
    int to;

    public SizeBlock(ASN1Encodable o) throws IOException {
        this.parse(o);
    }

    @Override
    protected final void parse(ASN1Encodable to) throws IOException {
        ASN1Sequence s1 = ASN1Sequence.getInstance((Object)to);
        ASN1TaggedObject tag = ASN1TaggedObject.getInstance((Object)s1.getObjectAt(0));
        this.type = SizeType.getById(tag.getTagNo());
        if (this.type == null) {
            throw new IOException("Unknown type in SizeType " + tag.getTagNo());
        }
        ASN1Sequence s2 = ASN1Sequence.getInstance((Object)tag.getBaseObject());
        int i2 = 0;
        this.from = ASN1Integer.getInstance((Object)s2.getObjectAt(i2++)).getValue().intValue();
        this.to = ASN1Integer.getInstance((Object)s2.getObjectAt(i2++)).getValue().intValue();
    }

    @Override
    public String dumpValueNotation(String prefix, DumpType dumptype) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.name().toLowerCase()).append(" {").append("\r\n");
        String s1 = "fromPercent";
        String s2 = "toPercent";
        if (this.type == SizeType.ABSOLUTE) {
            s1 = "fromAbsolute";
            s2 = "toAbsolute";
        }
        sb.append(prefix).append("  ").append(s1).append(this.from).append(',').append("\r\n");
        sb.append(prefix).append("  ").append(s2).append(this.to).append("\r\n");
        sb.append(prefix).append('}');
        return sb.toString();
    }

    @Override
    public ASN1Object toAsn1Object(DumpType dumpType) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add((ASN1Encodable)new ASN1Integer((long)this.from));
        v2.add((ASN1Encodable)new ASN1Integer((long)this.to));
        v.add((ASN1Encodable)new DERTaggedObject(this.type.getId(), (ASN1Encodable)new DERSequence(v2)));
        return new DERSequence(v);
    }

    private static enum SizeType {
        PERCENT(15001),
        ABSOLUTE(15101);

        int id;

        private SizeType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static SizeType getById(int id) {
            for (SizeType e : SizeType.values()) {
                if (e.id != id) continue;
                return e;
            }
            return null;
        }
    }
}

